####
#### TEEL TECHNOLOGIES
#### COPYRIGHT © [2023] [TEEL INC]. All rights reserved.
####

$INSTALLER_DIR = $PSScriptRoot

. "${INSTALLER_DIR}\..\conf\backups.ps1"

#================================================
#   DO NOT EDIT BELOW
#================================================

if ($args[0] -eq "pre_update_backup") {
  $BACKUP_TYPE = "all"
  $BACKUP_DATE_FORMAT = "YYYY-mm-dd"
  $BACKUP_DIR = "C:\teel_tech\backups\xbit_backups\automated"
}

New-Item -ItemType Directory -Force -Path $BACKUP_DIR

$date = Get-Date
if ($BACKUP_DATE_FORMAT -eq "YYYY-mm-dd") {
    $BACKUP_DATE = $date.ToString("yyyy-MM-dd")
} else {
    $BACKUP_DATE = $date.ToString("yyyy-MM-dd-HH-mm")
}

New-Item -ItemType Directory -Force -Path $BACKUP_DIR\xbit_backup_${BACKUP_DATE}\db

$CONTAINER_DATABASE_ID = docker ps --filter="label=com.xbitdcm.service=database" --format="{{.ID}}"
$CONTAINER_APPLICATION_ID = docker ps --filter="label=com.xbitdcm.service=application" --format="{{.ID}}"

Function get_database_backup
{
    echo "Performing database backup ..."
    docker exec -it $CONTAINER_DATABASE_ID sh -c "mysqldump -u${MYSQL_USER} -p${DATABASE_PASSWORD} -R xBit > /tmp/xbit_dump_${BACKUP_DATE}.sql"
    docker cp "${CONTAINER_DATABASE_ID}:/tmp/xbit_dump_$BACKUP_DATE.sql" ${BACKUP_DIR}\xbit_backup_${BACKUP_DATE}\db\xbit_dump_${BACKUP_DATE}.sql
    if ($?){
        docker exec -it $CONTAINER_DATABASE_ID sh -c "rm -rf /tmp/xbit_dump_$BACKUP_DATE.sql"
    } else {
        echo "ERROR: DB backup failed"
        exit 1
    }
}

Function get_persistent_backup
{
    echo "Performing config directory backup ..."
    docker cp ${CONTAINER_APPLICATION_ID}:/app/config ${BACKUP_DIR}\xbit_backup_${BACKUP_DATE}\
    if (!$?) {
        echo "ERROR: /app/config backup failed"
        exit 1
    }
    echo "config directory backup completed"

    echo "Performing csv directory  backup ..."
    docker cp ${CONTAINER_APPLICATION_ID}:/app/csv ${BACKUP_DIR}\xbit_backup_${BACKUP_DATE}\
    if (!$?) {
        echo "ERROR: /app/csv backup failed"
        exit 1
    }
    echo "csv directory backup completed"

    echo "Performing upload directory backup ..."
    docker cp ${CONTAINER_APPLICATION_ID}:/app/upload ${BACKUP_DIR}\xbit_backup_${BACKUP_DATE}\
    if (!$?) {
        echo "ERROR: /app/upload backup failed"
        exit 1
    }
    echo "upload directory backup completed"
}


if ($BACKUP_TYPE -eq "db"){
    get_database_backup
} elseif ($BACKUP_TYPE -eq "persistent_volumes"){
    get_persistent_backup
} else {
    get_database_backup
    get_persistent_backup
}

cd $BACKUP_DIR
echo "Performing backup directory archive creation"
Compress-Archive -Force -Path xbit_backup_${BACKUP_DATE} -DestinationPath xbit_backup_${BACKUP_DATE}.zip
if ($?){
    Remove-Item -LiteralPath "xbit_backup_${BACKUP_DATE}" -Force -Recurse
} else {
    echo "ERROR: Backup file create failed"
    exit 1
}

echo "xBit backup completed: ${$BACKUP_DIR}/xbit_backup_${BACKUP_DATE}.zip"