#!/usr/bin/env bash
####
#### TEEL TECHNOLOGIES
#### COPYRIGHT © [2023] [TEEL INC]. All rights reserved.
####

SCRIPT=$(realpath "$0")
SCRIPTPATH=$(dirname "$SCRIPT")

source $SCRIPTPATH/../conf/backup.conf

#================================================
#   DO NOT EDIT BELOW
#================================================

if [[ "$1" == "pre_update_backup" ]]; then
  BACKUP_TYPE=all
  BACKUP_DATE_FORMAT=YYYY-mm-dd
  BACKUP_DIR=$HOME/teel_tech/backups/xbit_backups/automated
fi

if [[ "${BACKUP_DATE_FORMAT}" == "YYYY-mm-dd" ]]; then
  BACKUP_DATE=$(date +'%F')
else
  BACKUP_DATE=$(date +'%F-%H-%M')
fi

mkdir -p ${BACKUP_DIR}/xbit_backup_${BACKUP_DATE}/db

CONTAINER_DATABASE_ID=`docker ps --filter="label=com.xbitdcm.service=database" --format="{{.ID}}"`
CONTAINER_APPLICATION_ID=`docker ps --filter="label=com.xbitdcm.service=application" --format="{{.ID}}"`

# Get Database dump
function get_database_backup()
{
  echo "Performing database backup ..."
  docker exec -it $CONTAINER_DATABASE_ID sh -c "mysqldump -u${MYSQL_USER} -p${DATABASE_PASSWORD} -R xBit > /tmp/xbit_dump_${BACKUP_DATE}.sql"
  docker cp $CONTAINER_DATABASE_ID:/tmp/xbit_dump_${BACKUP_DATE}.sql ${BACKUP_DIR}/xbit_backup_${BACKUP_DATE}/db/xbit_dump_${BACKUP_DATE}.sql
  if [[ $? -eq 0 ]]; then
    docker exec -it $CONTAINER_DATABASE_ID sh -c "rm -rf /tmp/xbit_dump_${BACKUP_DATE}.sql"
  else
    echo "ERROR: Database backup failed"
    exit 1
  fi
}

# Get Persistent volume backup
function get_persistent_backup()
{
  echo "Performing config directory backup ..."
  docker cp $CONTAINER_APPLICATION_ID:/app/config ${BACKUP_DIR}/xbit_backup_${BACKUP_DATE}/
  if [[ $? -ne 0 ]]; then
    echo "ERROR: /app/config backup failed"
    exit 1
  fi
  echo "config directory backup completed"

  echo "Performing csv directory  backup ..."
  docker cp $CONTAINER_APPLICATION_ID:/app/csv ${BACKUP_DIR}/xbit_backup_${BACKUP_DATE}/
  if [[ $? -ne 0 ]]; then
    echo "ERROR: /app/csv backup failed"
    exit 1
  fi
  echo "csv directory backup completed"

  echo "Performing upload directory backup ..."
  docker cp $CONTAINER_APPLICATION_ID:/app/upload ${BACKUP_DIR}/xbit_backup_${BACKUP_DATE}/
  if [[ $? -ne 0 ]]; then
    echo "ERROR: /app/upload backup failed"
    exit 1
  fi
  echo "upload directory backup completed"
}


if [[ "${BACKUP_TYPE}" == "db" ]]; then
  get_database_backup
elif [[ "${BACKUP_TYPE}" == "persistent_volumes" ]]; then
  get_persistent_backup
else
  get_database_backup
  get_persistent_backup
fi

# Creating a backup archive
echo "Performing backup directory archive creation"
cd ${BACKUP_DIR}
if [[ -f xbit_backup_${BACKUP_DATE}.tar.gz ]]; then
  rm -rf xbit_backup_${BACKUP_DATE}.tar.gz
fi
tar -zcf xbit_backup_${BACKUP_DATE}.tar.gz xbit_backup_${BACKUP_DATE}
if [[ $? -eq 0 ]]; then
  rm -rf ${BACKUP_DIR}/xbit_backup_${BACKUP_DATE}
else
  echo "ERROR: Backup file creation failed"
  exit 1
fi

echo "xBit backup completed: $BACKUP_DIR/xbit_backup_${BACKUP_DATE}.tar.gz"