# xBit On-Prem Backup

This utility will take the xBit Data backup and stored locally. Customer can schedule this from task scheduler 
or Cron job for daily backups and transfer the created backup archive to external location. 

## Usage

Based on the deployment type (Windows / Linux), place the Backup utility and configure the backup configuration 
file

### Windows

- Create a backup location and extract the `xbit_onprem_backup-<APPLICATION_VERSION>.zip`

   **Default Directory :** "C:\teel_tech\backups\xbit_backups"

- Update `windows\conf\backups.ps1` according to the requirement and xBit deployment
  - Variables to be set: 
    - `$BACKUP_DIR` - Default :  "C:\teel_tech\backups\xbit_backups\automated"
    - `$BACKUP_TYPE` - Default : "all". Options = all|db|persistent_volumes
    - `$BACKUP_DATE_FORMAT` - Default : "YYYY-mm-dd" # Options = YYYY-mm-dd|YYYY-mm-dd-HH-MM
    - `$DATABASE_PASSWORD`
    - `$MYSQL_USER`


- Run the `xbit_onpremise_backup.ps1`
  ```
  cd windows\bin
  .\xbit_onpremise_backup.ps1
  ```
  
> **Note:** Above script can be used as a scheduled task. 


### Linux

- Create a backup location and extract the `xbit_onprem_backup-<APPLICATION_VERSION>.zip`

   **Default Directory :** "$HOME/teel_tech/backups/xbit_backups/"

- Update `linux/conf/backup.conf` according to the requirement and xBit deployment
  - Variables to be set: 
    - `BACKUP_DIR` - Default :  "$HOME/teel_tech/backups/xbit_backups/automated"
    - `BACKUP_TYPE` - Default : "all". Options = all|db|persistent_volumes
    - `BACKUP_DATE_FORMAT` - Default : "YYYY-mm-dd" # Options = YYYY-mm-dd|YYYY-mm-dd-HH-MM
    - `DATABASE_PASSWORD`
    - `MYSQL_USER`


- Run the `xbit_onpremise_backup.sh`
  ```
  cd linux/bin
  ./xbit_onpremise_backup.sh
  ```

<br>

**Note:** Above script can be used as a cron task. 
>  
> **E.g:** 
> 
> `30 1 * * * sh $HOME/teel_tech/backups/xbit_backups/xbit_onprem_backup-<APPLICATION_VERSION>/linux/bin/xbit_onpremise_backup.sh`